class MW_HUD extends ChallengeHUD config;

//----------- custom variables:
var MW_GRI GRI;
var MW_PRI PRI;
var color CycleColor;
var byte CC;
var bool bCycleUp;
//------------------------------
#exec OBJ LOAD FILE=..\Textures\LadrStatic.utx PACKAGE=Botpack.LadrStatic

var() int SizeY,Count;
var string CurrentMessage;
var float MOTDFadeOutTime;

var float IdentifyFadeTime;
var PlayerReplicationInfo IdentifyTarget;
var Pawn PawnOwner;	// pawn currently managing this HUD (may be the viewtarget of the owner rather than the owner)
var FontInfo MyFonts;

// Localized Messages
var HUDLocalizedMessage ShortMessageQueue[4];
var HUDLocalizedMessage LocalMessages[10];

var texture FaceTexture;
var float FaceTime;
var color FaceTeam;
 
var() localized string VersionMessage, PlayerCountString;
var localized string MapTitleString, AuthorString;
var localized string MapTitleString2, AuthorString2;

var localized string RankString;
var localized string SpreadString;

var int PlayerCount;
var bool bTiedScore;

var string ReceivedMessage;
var string ReceivedName;
var ZoneInfo ReceivedZone;
var float ReceivedTime;
var texture TutIconTex;
var int TutIconX, TutIconY;
var float TutIconBlink;

//var globalconfig int CrosshairCount;
//var globalconfig string CrossHairs[20];
var texture CrossHairTextures[20];

var texture GrayWeapons[11];
var texture FP1[3], FP2[3], FP3[3];
var int LastReportedTime;
var bool bStartUpMessage, bForceScores;
var bool bTimeValid;
var bool bLowRes;
var bool bResChanged;
var int OldClipX;

// configuration options
var bool bAlwaysHideFrags, bHideCenterMessages;
//var globalconfig bool bHideAllWeapons, bHideStatus, bHideAmmo, bHideTeamInfo, bHideFrags, bHideHUD, bHideNoviceMessages, bHideFaces;
//var globalconfig bool bUseTeamColor;
//var globalconfig byte Opacity;	// should be between 1 and 16
//var globalconfig float HUDScale, StatusScale, WeaponScale;
//var globalconfig color FavoriteHUDColor, CrosshairColor;
var float Scale;
var byte Style;
var color BaseColor, WhiteColor, RedColor, GreenColor, CyanColor, UnitColor, BlueColor,
		 GoldColor, HUDColor, SolidHUDColor, PurpleColor, TurqColor, GrayColor, FaceColor;

// Identify Strings
var localized string IdentifyName, IdentifyHealth, IdentifyCallsign;
var localized string LiveFeed;

// scoring 
var float ScoreTime;
var int rank, lead;

// showing damage
var vector HitPos[4];
var float HitTime[4];
var float HitDamage[4];

var float PickupTime;

var float WeaponNameFade;
var float MessageFadeTime;
var int MessageFadeCount;
var bool bDrawMessageArea;
var bool bDrawFaceArea;
var float FaceAreaOffset, MinFaceAreaOffset;
var class<CriticalEventPlus> TimeMessageClass;

// Server info.
var ServerInfo ServerInfo;
var bool bShowInfo;

var class<ServerInfo> ServerInfoClass;

//var globalconfig string FontInfoClass;

// Setup HUD Elements:
simulated function SetupHUDElements(Canvas Canvas)
{
local float XL, YL;

//Background Bar:
Canvas.SetPos(0, Canvas.ClipY - 32);
Canvas.DrawColor = BlueColor;
Canvas.Style = ERenderStyle.STY_Translucent;
Canvas.DrawTile(Texture'Element_Bar', Canvas.ClipX, 32, 0, 0, 2, 32);

//Health Element:
Canvas.SetPos(4, Canvas.ClipY - 64);
Canvas.DrawColor = WhiteColor;
Canvas.Style = ERenderStyle.STY_Normal;
Canvas.DrawTile(Texture'Element_Health', 32, 64, 0, 0, 32, 64);
Canvas.SetPos(4, Canvas.ClipY - 64);
Canvas.Style = ERenderStyle.STY_Translucent;
Canvas.DrawTile(Texture'Icon_Heart', 32, 32, 0, 0, 32, 32);

//Ammo Element:
Canvas.SetPos(Canvas.ClipX - 36, Canvas.ClipY - 64);
Canvas.DrawColor = WhiteColor;
Canvas.DrawTile(Texture'Element_Health', 32, 64, 0, 0, 32, 64);
Canvas.SetPos(Canvas.ClipX - 36, Canvas.ClipY - 64);
Canvas.Style = ERenderStyle.STY_Translucent;
Canvas.DrawTile(Texture'Icon_Ammo', 32, 32, 0, 0, 32, 32);

//Level Element:
Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Canvas.ClipY - 32);
Canvas.DrawColor = WhiteColor;
Canvas.DrawTile(Texture'Element_NextLevel', 128, 32, 0, 0, 128, 32);

//Weapon Element:
Canvas.Font = MyFonts.GetSmallestFont( 800 );
Canvas.StrLen("TEST", XL, YL);
Canvas.SetPos(40, Canvas.ClipY - 64);
Canvas.DrawColor = WhiteColor;
Canvas.DrawTile(Texture'Element_Weapon', 64, 64, 0, 0, 64, 64);
}

// Draw Players Health Info:
simulated function DrawHealth(Canvas Canvas)
{
local float MaxHealth, CurrentHealth, DrawScale, XL, YL;

	Canvas.Font = MyFonts.GetSmallestFont( 800 );
	MaxHealth = 100;	//This should be changed to a custom PRI MaxHealth variable
	CurrentHealth = PlayerPawn(Owner).Health;
	DrawScale = CurrentHealth / MaxHealth;
	Canvas.SetPos(6, Canvas.ClipY - 62 * DrawScale);
	Canvas.DrawTile(Texture'Color_Red', 28, 60 * DrawScale, 0, 0, 2, 2);

	if (CurrentHealth < 0)
		CurrentHealth = 0;
	Canvas.StrLen(int(CurrentHealth), XL, YL);
	Canvas.SetPos(20 - 0.5 * XL, Canvas.ClipY - 2 - YL);
	Canvas.DrawText(int(CurrentHealth), False);
}

/* draw the ammo count of the current weapon (if any) */
simulated function DrawAmmo(Canvas Canvas)
{
local float MaxAmmo, CurrentAmmo, DrawScale, XL, YL;
local bool bHasAmmo;
	if ( PlayerPawn(Owner).Weapon != None )
		{
		if ( PlayerPawn(Owner).Weapon.AmmoType != None )
			{
			MaxAmmo = PlayerPawn(Owner).Weapon.AmmoType.MaxAmmo;
			CurrentAmmo	= PlayerPawn(Owner).Weapon.AmmoType.AmmoAmount;
			DrawScale = CurrentAmmo / MaxAmmo;
			bHasAmmo = True;
			}
		}
	if ( !bHasAmmo )
		DrawScale = 1;
	Canvas.Font = MyFonts.GetSmallestFont( 800 );
	Canvas.SetPos(Canvas.ClipX - 34, Canvas.ClipY - 62 * DrawScale);
	if ( DrawScale > 0.33 )
		Canvas.DrawTile(Texture'Color_Green', 28, 60 * DrawScale, 0, 0, 2, 2);
	else if ( DrawScale > 0.175 )
		Canvas.DrawTile(Texture'Color_Gold', 28, 60 * DrawScale, 0, 0, 2, 2);
	else
		Canvas.DrawTile(Texture'Color_Red', 28, 60 * DrawScale, 0, 0, 2, 2);
	if ( bHasAmmo )
		{
		Canvas.StrLen(int(CurrentAmmo), XL, YL);
		Canvas.SetPos(Canvas.ClipX - 20 - 0.5 * XL, Canvas.ClipY - 2 - YL);
		Canvas.DrawText(int(CurrentAmmo), False);
		}
}

// Draw numbers of Players and enemies:
simulated function DrawLeftInfo(Canvas Canvas)
{
local float XL, YL;

	Canvas.Font = MyFonts.GetSmallestFont( 800 );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetPos(0, Canvas.ClipY * 0.5);
	Canvas.DrawText("Players:"@GRI.NumPlayers, False);
	Canvas.SetPos(0, Canvas.ClipY * 0.5 + YL);
	Canvas.DrawText("Enemies:"@GRI.NumEnemies, False);
}

// Draw stat and skill points:
simulated function DrawRightInfo(Canvas Canvas)
{
local float XL, YL;

	Canvas.Font = MyFonts.GetBigFont( 800 );
	
	Canvas.SetPos(Canvas.ClipX - 64, 0);
	Canvas.Style = ERenderStyle.STY_Translucent;
	
	if ( PRI.StatPoints > 0 )
		Canvas.DrawTile(Texture'Statpoint_on', 64, 64, 0, 0, 64, 64);
	else
		Canvas.DrawTile(Texture'Statpoint_off', 64, 64, 0, 0, 64, 64);
		
	Canvas.StrLen(PRI.StatPoints, XL, YL);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX - 32 - 0.5 * XL, 64);
	Canvas.DrawText(PRI.StatPoints, False);
	
	Canvas.SetPos(Canvas.ClipX - 64, 64 + YL);
	Canvas.Style = ERenderStyle.STY_Translucent;
	
	if ( PRI.SkillPoints > 0 )
		Canvas.DrawTile(Texture'Skillpoint_on', 64, 64, 0, 0, 64, 64);
	else
		Canvas.DrawTile(Texture'Skillpoint_off', 64, 64, 0, 0, 64, 64);
		
	Canvas.StrLen(PRI.SkillPoints, XL, YL);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX - 32 - 0.5 * XL, 128 + YL);
	Canvas.DrawText(PRI.SkillPoints, False);
	
	Canvas.SetPos(Canvas.ClipX - 64, 2 * (64 + YL) );
	Canvas.Style = ERenderStyle.STY_Translucent;
	
	Canvas.DrawTile(Texture'Icon_Dollar', 64, 64, 0, 0, 64, 64);
		
	Canvas.StrLen(PRI.Money, XL, YL);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX - 32 - 0.5 * XL, 192 + 2 * YL);
	Canvas.DrawText(PRI.Money, False);
}

Simulated function DrawLevelInfo(Canvas Canvas)
{
local float XL, YL;

	Canvas.Font = MyFonts.GetSmallFont( 800 );
	Canvas.StrLen("Score:"@PRI.DamageDone, XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - 32 - YL);
	Canvas.DrawText("Score:"@PRI.DamageDone, False);
	Canvas.StrLen("Level:"@PRI.Level, XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - 12 - YL);
	Canvas.DrawText("Level:"@PRI.Level, False);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 61, Canvas.ClipY - 7);
	Canvas.DrawTile(Texture'Color_White', 122 * PRI.PCTNextLevel, 4, 0, 0, 2, 2);
}

simulated function DrawPlayerInfo(Canvas Canvas)
{
local int i,t;
local float Y,XL,YL;
Local inventory Inv;
local Texture weapons[8];
local string SlaveWeapon[8];
local color OldColor;

	OldColor = Canvas.DrawColor;

	//Draw Background:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400, Canvas.ClipY * 0.5 - 300);
	Canvas.DrawTile(Texture'UWindow.Icons.Background', 800, 600, 0, 0, 800, 600);
	//Draw Frame:
	Canvas.SetPos(Canvas.ClipX * 0.5 - 432, Canvas.ClipY * 0.5 - 332);
	Canvas.DrawTile(Texture'Frame_TopLeft', 32, 32, 0, 0, 32, 32);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400, Canvas.ClipY * 0.5 - 332);
	Canvas.DrawTile(Texture'Frame_TopMid', 800, 32, 0, 0, 800, 32);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 400, Canvas.ClipY * 0.5 - 332);
	Canvas.DrawTile(Texture'Frame_TopRight', 32, 32, 0, 0, 32, 32);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 432, Canvas.ClipY * 0.5 - 300);
	Canvas.DrawTile(Texture'Frame_LeftMid', 32, 600, 0, 0, 32, 600);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 432, Canvas.ClipY * 0.5 + 300);
	Canvas.DrawTile(Texture'Frame_BottomLeft', 32, 32, 0, 0, 32, 32);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400, Canvas.ClipY * 0.5 + 300);
	Canvas.DrawTile(Texture'Frame_BottomMid', 800, 32, 0, 0, 800, 32);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 400, Canvas.ClipY * 0.5 + 300);
	Canvas.DrawTile(Texture'Frame_RightBottom', 32, 32, 0, 0, 32, 32);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 400, Canvas.ClipY * 0.5 - 300);
	Canvas.DrawTile(Texture'Frame_RightMid', 32, 600, 0, 0, 32, 600);
	//Draw Headline:
	Canvas.Font = MyFonts.GetHugeFont( 800 );
	Canvas.StrLen("Your current loadout:", XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 - 298);
	Canvas.DrawText("Your current loadout:", False);
	//Draw Weapon frames:
	Canvas.Font = MyFonts.GetSmallFont( 800 );
	Canvas.StrLen("Weapons:", XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 352 - 0.5 * XL, Canvas.ClipY * 0.5 - 292);
	Canvas.DrawText("Weapons:", False);
	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if ( Inv.IsA('MercWarriorsWeapon') && t < 8)
			{
			weapons[t] = MercWarriorsWeapon(Inv).Image;
			if ( Inv.IsA('Weapon_BaseEnforcer') && Weapon_BaseEnforcer(Inv).SlaveEnforcer != none )
				SlaveWeapon[t] = "True";
			else
				SlaveWeapon[t] = "False";
			t++;
			}
		}
	Y = Canvas.ClipY * 0.5 - 270;
	for ( i=0;i<8;i++)
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 + 320, Y);
		Canvas.DrawTile(Texture'Element_Weapon', 64, 64, 0, 0, 64, 64);
		if ( weapons[i] != none )
			{
			Canvas.SetPos(Canvas.ClipX * 0.5 + 322, Y + 2);
			Canvas.DrawTile(weapons[i], 60, 60, 2, 2, 64, 64);
			if ( SlaveWeapon[i] == "True" )
				{
				Canvas.Font = MyFonts.GetSmallestFont( 800 );
				Canvas.StrLen("x2", XL, YL);
				Canvas.SetPos(Canvas.ClipX * 0.5 + 380 - XL, Y + 62 - YL);
				Canvas.DrawText("x2", False);
				}
			if ( weapons[i] == MercWarriorsWeapon(PlayerPawn(Owner).Weapon).Image )
				{
				Canvas.DrawColor = CycleColor;
				Canvas.SetPos(Canvas.ClipX * 0.5 + 318, Y - 2);
				Canvas.Style = ERenderStyle.STY_Translucent;
				Canvas.DrawTile(Texture'Element_CurrentWeapon', 68, 68, 0, 0, 64, 64);
				Canvas.Style = ERenderStyle.STY_Normal;
				Canvas.DrawColor = OldColor;
				}
			}
		Y += 68;
		}
}

function CycleCC()
{
CycleColor.R = CC;
CycleColor.G = CC;
CycleColor.B = CC;

if ( bCycleUp )
	{
	CC += 5;
	if ( CC >= 255 )
		{
		CC = 255;
		bCycleUp = False;
		}
	}
else
	{
	CC -= 5;
	if ( CC <= 0 )
		{
		CC = 0;
		bCycleUp = True;
		}
	}
}

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

simulated function PostBeginPlay()
{
	local int i;

	if ( Level.NetMode != NM_Standalone )
		MOTDFadeOutTime = 350;
	FaceAreaOffset = -64;
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(FontInfoClass, class'Class'))));
	Super.PostBeginPlay();
	SetTimer(1.0, True);

	if ( (PlayerPawn(Owner).GameReplicationInfo != None)
		&& (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) )
		TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

	ServerInfo = Spawn(ServerInfoClass, Owner);
	GRI = MW_GRI(PlayerPawn(Owner).GameReplicationInfo);
	PRI = MW_PRI(PlayerPawn(Owner).PlayerReplicationInfo);
}

exec function ShowServerInfo()
{
	if (bShowInfo)
	{
		bShowInfo = False;
	} else {
		bShowInfo = True;
		PlayerPawn(Owner).bShowScores = False;
	}
}

simulated function ChangeCrosshair(int d)
{
	Crosshair = Crosshair + d;
	if ( Crosshair >= CrossHairCount )
		Crosshair = 0;
	else
	if ( Crosshair < 0 )
		Crosshair = CrossHairCount-1;
}

simulated function Texture LoadCrosshair(int c)
{
	CrossHairTextures[c] = Texture(DynamicLoadObject(CrossHairs[c], class'Texture'));
	return CrossHairTextures[c];
}

simulated function HUDSetup(canvas canvas)
{
	local int FontSize;

	bResChanged = (Canvas.ClipX != OldClipX);
	OldClipX = Canvas.ClipX;
		
	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner.ViewTarget == None )
		PawnOwner = PlayerOwner;
	else if ( PlayerOwner.ViewTarget.bIsPawn )
		PawnOwner = Pawn(PlayerOwner.ViewTarget);
	else 
		PawnOwner = PlayerOwner;

	// Setup the way we want to draw all HUD elements
	Canvas.Reset();
	Canvas.SpaceX=0;
	Canvas.bNoSmooth = True;

	FontSize = Min(3, HUDScale * Canvas.ClipX/500);
	Scale = (HUDScale * Canvas.ClipX)/1280.0;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	SolidHUDColor = FavoriteHUDColor * 15.9;
	if ( (Opacity == 16) || !Level.bHighDetailMode )
	{
		Style = ERenderStyle.STY_Normal;
		BaseColor = WhiteColor;
		HUDColor = SolidHUDColor;
	}
	else
	{
		Style = ERenderStyle.STY_Translucent;
		BaseColor = (16 * Opacity + 15) * UnitColor;
		HUDColor = FavoriteHUDColor * (Opacity + 0.9);
	}
	Canvas.DrawColor = BaseColor;
	Canvas.Style = Style;
	bLowRes = ( Canvas.ClipX < 400 );
	if ( bLowRes )
		WeaponScale = 1.0;
}

/* This funtion draws the weapons icon, name and damage on the HUD */
simulated function DrawWeapons(Canvas Canvas)
{
local MercWarriorsWeapon W;
local float XL, YL;

	Canvas.Font = MyFonts.GetSmallestFont( 800 );
	Canvas.StrLen("TEST", XL, YL);

	if ( PawnOwner.Weapon != None && PawnOwner.Weapon.IsA('MercWarriorsWeapon') )
		{
		W = MercWarriorsWeapon(PawnOwner.Weapon);
		if ( W.Image != none )
			{
			Canvas.SetPos(42, Canvas.ClipY - 62);
			Canvas.DrawTile(W.Image, 60, 60, 2, 2, 64, 64);
			}
		if ( W.ItemName != "" && W.WeaponClass != "" )
			{
			Canvas.SetPos(104, Canvas.ClipY - YL);
			Canvas.DrawColor = W.ItemColor;
			Canvas.DrawText(W.WeaponClass@W.ItemName, False);
			Canvas.SetPos(104, Canvas.ClipY - 2 * YL);
			Canvas.DrawText(W.DamageString, False);
			}
		}
}

simulated function DisplayProgressMessage( canvas Canvas )
{
	local int i;
	local float XL, YL, YOffset;
	local GameReplicationInfo GRI;

	PlayerOwner.ProgressTimeOut = FMin(PlayerOwner.ProgressTimeOut, Level.TimeSeconds + 8);
	Canvas.Style = ERenderStyle.STY_Normal;	

	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	if ( UTIntro(Level.Game) != None )
		YOffset = 64 * scale + 2 * YL;
	else if ( (MOTDFadeOutTime <= 0) || (Canvas.ClipY < 300) )
		YOffset = 64 * scale + 6 * YL;
	else
	{
		YOffset = 64 * scale + 6 * YL;
		GRI = PlayerOwner.GameReplicationInfo;
		if ( GRI != None )
		{
			if ( GRI.MOTDLine1 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine2 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine3 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine4 != "" )
				YOffset += YL;
		}
	}
	for (i=0; i<8; i++)
	{
		Canvas.SetPos(0, YOffset);
		Canvas.DrawColor = PlayerPawn(Owner).ProgressColor[i];
		Canvas.DrawText(PlayerPawn(Owner).ProgressMessage[i], False);
		YOffset += YL + 1;
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.bCenter = False;
	HUDSetup(Canvas);	
}

function DrawTalkFace(Canvas Canvas, int i, float YPos)
{
	if ( !bHideHUD && !PawnOwner.PlayerReplicationInfo.bIsSpectator )
	{
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(FaceAreaOffset + 4*Scale, 4*Scale);
		Canvas.DrawTile(FaceTexture, YPos - 1*Scale, YPos - 1*Scale, 0, 0, FaceTexture.USize, FaceTexture.VSize);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = FaceColor;
		Canvas.SetPos(FaceAreaOffset, 0);
		Canvas.DrawTile(texture'LadrStatic.Static_a00', YPos + 7*Scale, YPos + 7*Scale, 0, 0, texture'LadrStatic.Static_a00'.USize, texture'LadrStatic.Static_a00'.VSize);
		Canvas.DrawColor = WhiteColor;
	}
}

function bool DrawSpeechArea( Canvas Canvas, float XL, float YL )
{
	local float YPos, Yadj;
	local float WackNumber;
	local int paneltype;

	YPos = FMax(YL*4 + 8, 70*Scale);
	Yadj = YPos + 7*Scale;
	YPos *=2;
	MinFaceAreaOffset = -1 * Yadj;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = HUDColor * MessageFadeTime;

	Canvas.SetPos(FaceAreaOffset, 0);
	Canvas.DrawTile(texture'LadrStatic.Static_a00', Yadj, Yadj, 0, 0, texture'LadrStatic.Static_a00'.USize, texture'LadrStatic.Static_a00'.VSize);

	WackNumber = 512*Scale - 64 + FaceAreaOffset; // 256*Scale - (512*Scale - (768*Scale - 64 + FaceAreaOffset));
	if ( !PlayerOwner.Player.Console.bTyping )
		paneltype = 0;
	else 
	{
		Canvas.StrLen("(>"@PlayerOwner.Player.Console.TypedStr$"_", XL, YL);
		if (XL < 768*Scale)
			paneltype = 1;
		else 
			paneltype = 2;
	}

	Canvas.SetPos(Yadj + FaceAreaOffset, 0);
	Canvas.DrawTile(FP1[paneltype], 256*Scale - FaceAreaOffset, YPos, 0, 0, FP1[paneltype].USize, FP1[paneltype].VSize);

	Yadj += 256 * Scale;
	Canvas.SetPos(Yadj, 0);
	Canvas.DrawTile(FP2[paneltype], WackNumber, YPos, 0, 0, FP2[paneltype].USize, FP2[paneltype].VSize);

	Canvas.SetPos(Yadj + WackNumber, 0);
	Canvas.DrawTile(FP3[paneltype], 64, YPos, 0, 0, FP3[paneltype].USize, FP3[paneltype].VSize);
}

//========================================
// Master HUD render function.

simulated function PostRender( canvas Canvas )
{
	local float XL, YL, XPos, YPos, FadeValue;
	local string Message;
	local int M, i, j, k, XOverflow;
	local float OldOriginX;

	HUDSetup(canvas);
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	if ( !PawnOwner.PlayerReplicationInfo.bIsSpectator )
		{
		SetupHUDElements(Canvas);
		DrawHealth(Canvas);
		DrawAmmo(Canvas);
		DrawLeftInfo(Canvas);		//draw the current numbers of players and enemies
		DrawRightInfo(Canvas);		//draw stat and skill points
		DrawLevelInfo(Canvas);		//draw current score and level progress
		DrawWeapons(Canvas);
		DrawPickups(Canvas);
		DrawEnemies(Canvas);

		if ( HUDMutator != None )
			HUDMutator.PostRender(Canvas);

		if ( (PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) ) 
		{
			if ( TimeMessageClass == None )
				TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

			if ( (PlayerOwner.GameReplicationInfo.RemainingTime <= 300)
			  && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime) )
			{
				LastReportedTime = PlayerOwner.GameReplicationInfo.RemainingTime;
				if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 30 )
				{
					bTimeValid = ( bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) );	
					if ( PlayerOwner.GameReplicationInfo.RemainingTime == 30 )
						TellTime(5);
					else if ( bTimeValid && PlayerOwner.GameReplicationInfo.RemainingTime <= 10 )
						TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
				}
				else if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0 )
				{
					M = PlayerOwner.GameReplicationInfo.RemainingTime/60;
					TellTime(5 - M);
				}
			}
		}
	
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	OldOriginX = Canvas.OrgX;
	// Master message short queue control loop.
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetClip(768*Scale - 10, Canvas.ClipY);
	bDrawFaceArea = false;
	if ( !bHideFaces && !PlayerOwner.bShowScores && !bForceScores && !bHideHUD 
			&& !PawnOwner.PlayerReplicationInfo.bIsSpectator && (Scale >= 0.4) )
	{
		DrawSpeechArea(Canvas, XL, YL);
		bDrawFaceArea = (FaceTexture != None) && (FaceTime > Level.TimeSeconds);
		if ( bDrawFaceArea )
		{
			if ( !bHideHUD && ((PawnOwner.PlayerReplicationInfo == None) || !PawnOwner.PlayerReplicationInfo.bIsSpectator) )
				Canvas.SetOrigin( FMax(YL*4 + 8, 70*Scale) + 7*Scale + 6 + FaceAreaOffset, Canvas.OrgY );
		}
	}

	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message != None )
		{
			j++;

			if ( bResChanged || (ShortMessageQueue[i].XL == 0) )
			{
				if ( ShortMessageQueue[i].Message.Default.bComplexString )
					Canvas.StrLen(ShortMessageQueue[i].Message.Static.AssembleString( 
											self,
											ShortMessageQueue[i].Switch,
											ShortMessageQueue[i].RelatedPRI,
											ShortMessageQueue[i].StringMessage), 
								   ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				else
					Canvas.StrLen(ShortMessageQueue[i].StringMessage, ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				Canvas.StrLen("TEST", XL, YL);
				ShortMessageQueue[i].numLines = 1;
				if ( ShortMessageQueue[i].YL > YL )
				{
					ShortMessageQueue[i].numLines++;
					for (k=2; k<4-i; k++)
					{
						if (ShortMessageQueue[i].YL > YL*k)
							ShortMessageQueue[i].numLines++;
					}
				}
			}

			// Keep track of the amount of lines a message overflows, to offset the next message with.
			Canvas.SetPos(6, 2 + YL * YPos);
			YPos += ShortMessageQueue[i].numLines;
			if ( YPos > 4 )
				break; 

			if ( ShortMessageQueue[i].Message.Default.bComplexString )
			{
				// Use this for string messages with multiple colors.
				ShortMessageQueue[i].Message.Static.RenderComplexMessage( 
					Canvas,
					ShortMessageQueue[i].XL,  YL,
					ShortMessageQueue[i].StringMessage,
					ShortMessageQueue[i].Switch,
					ShortMessageQueue[i].RelatedPRI,
					None,
					ShortMessageQueue[i].OptionalObject
					);				
			} 
			else
			{
				Canvas.DrawColor = ShortMessageQueue[i].Message.Default.DrawColor;
				Canvas.DrawText(ShortMessageQueue[i].StringMessage, False);
			}
		}
	}

	Canvas.DrawColor = WhiteColor;
	Canvas.SetClip(OldClipX, Canvas.ClipY);
	Canvas.SetOrigin(OldOriginX, Canvas.OrgY);

	if ( PlayerOwner.bShowScores || bForceScores )
	{
		if ( (PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None) )
			PlayerOwner.Scoring = Spawn(PlayerOwner.ScoringType, PlayerOwner);
		if ( PlayerOwner.Scoring != None )
		{ 
			PlayerOwner.Scoring.OwnerHUD = self;
			PlayerOwner.Scoring.ShowScores(Canvas);
			if ( PlayerOwner.Player.Console.bTyping )
				DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);
			return;
		}
	}

	YPos = FMax(YL*4 + 8, 70*Scale);
	if ( bDrawFaceArea )
		DrawTalkFace( Canvas,0, YPos );
	if (j > 0) 
	{
		bDrawMessageArea = True;
		MessageFadeCount = 2;
	} 
	else 
		bDrawMessageArea = False;

	if ( !bHideCenterMessages )
	{
		// Master localized message control loop.
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message != None)
			{
				if (LocalMessages[i].Message.Default.bFadeMessage && Level.bHighDetailMode)
				{
					Canvas.Style = ERenderStyle.STY_Translucent;
					FadeValue = (LocalMessages[i].EndOfLife - Level.TimeSeconds);
					if (FadeValue > 0.0)
					{
						if ( bResChanged || (LocalMessages[i].XL == 0) )
						{
							if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
								LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
							else // ==2
								LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
							Canvas.Font = LocalMessages[i].StringFont;
							Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
							LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
						}
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.DrawColor = LocalMessages[i].DrawColor * (FadeValue/LocalMessages[i].LifeTime);
						Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
						Canvas.DrawText( LocalMessages[i].StringMessage, False );
					}
				} 
				else 
				{
					if ( bResChanged || (LocalMessages[i].XL == 0) )
					{
						if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
							LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
						else // == 2
							LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
						LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
					}
					Canvas.Font = LocalMessages[i].StringFont;
					Canvas.Style = ERenderStyle.STY_Normal;
					Canvas.DrawColor = LocalMessages[i].DrawColor;
					Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
					Canvas.DrawText( LocalMessages[i].StringMessage, False );
				}
			}
		}
	}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == LEVACT_None) )
	{
		Canvas.DrawColor = WhiteColor;
		PawnOwner.Weapon.PostRender(Canvas);
		if ( !PawnOwner.Weapon.bOwnsCrossHair && !bShowInfo )
			DrawCrossHair(Canvas, 0,0 );
	}

	if ( (PawnOwner != Owner) && PawnOwner.bIsPlayer )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.bCenter = true;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = CyanColor * TutIconBlink;
		Canvas.SetPos(4, Canvas.ClipY - 96 * Scale);
		Canvas.DrawText( LiveFeed$PawnOwner.PlayerReplicationInfo.PlayerName, true );
		Canvas.bCenter = false;
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = Style;
	}

	if ( bStartUpMessage && (Level.TimeSeconds < 5) )
	{
		bStartUpMessage = false;
		PlayerOwner.SetProgressTime(7);
	}
	if ( (PlayerOwner.ProgressTimeOut > Level.TimeSeconds) && !bHideCenterMessages )
		DisplayProgressMessage(Canvas);

	// Display MOTD
	if ( MOTDFadeOutTime > 0.0 )
		DrawMOTD(Canvas);
	}
	if ( PlayerOwner.Player.Console.bTyping )
		DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);

	if ( PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5) )
	{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - (64*Scale), Canvas.ClipY / 2);
		Canvas.DrawIcon(texture'DisconnectWarn', Scale);
	}
	
	if ( bShowInfo )
		{
		DrawPlayerInfo(Canvas);
		//return;
		}
}

function Timer()
{
	local int i, j;

	if (!bDrawMessageArea)
	{
		if (MessageFadeCount > 0)
			MessageFadeCount--;
	}

	// Age the short message queue.
	for (i=0; i<4; i++)
	{
		// Purge expired messages.
		if ( (ShortMessageQueue[i].Message != None) && (Level.TimeSeconds >= ShortMessageQueue[i].EndOfLife) )
			ClearMessage(ShortMessageQueue[i]);
	}

	// Clean empty slots.
	for (i=0; i<3; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			for (j=i; j<4; j++)
			{
				if ( ShortMessageQueue[j].Message != None )
				{
					CopyMessage(ShortMessageQueue[i],ShortMessageQueue[j]);
					ClearMessage(ShortMessageQueue[j]);
					break;
				}
			}
		}
	}

	// Age all localized messages.
	for (i=0; i<10; i++)
	{
		// Purge expired messages.
		if ( (LocalMessages[i].Message != None) && (Level.TimeSeconds >= LocalMessages[i].EndOfLife) )
			ClearMessage(LocalMessages[i]);
	}

	// Clean empty slots.
	for (i=0; i<9; i++)
	{
		if ( LocalMessages[i].Message == None )
		{
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);
			ClearMessage(LocalMessages[i+1]);
		}
	}

	if ( (PlayerOwner == None) || (PawnOwner == None) || (PlayerOwner.GameReplicationInfo == None)
		|| (PawnOwner.PlayerReplicationInfo == None) )
		return;

}


simulated function TellTime(int num)
{
	PlayerOwner.ReceiveLocalizedMessage( TimeMessageClass, Num );
}

simulated function Tick(float DeltaTime)
{
local int i;

	Super.Tick(DeltaTime);

	CycleCC();
	
	IdentifyFadeTime = FMax(0.0, IdentifyFadeTime - DeltaTime);
	MOTDFadeOutTime = FMax(0.0, MOTDFadeOutTime - DeltaTime * 55);
	
	TutIconBlink += DeltaTime;
	if (TutIconBlink >= 0.5)
		TutIconBlink = 0.0;

	if ( bDrawFaceArea )
	{
		if ( FaceAreaOffset < 0 )
			FaceAreaOffset += DeltaTime * 600;
		if ( FaceAreaOffset > 0 )
			FaceAreaOffset = 0.0;
	} 
	else if ( FaceAreaOffset > MinFaceAreaOffset )
		FaceAreaOffset = FMax(FaceAreaOffset - DeltaTime * 600, MinFaceAreaOffset );

	if ( bDrawMessageArea )
	{
		if ( MessageFadeTime < 1.0 )
		{
			MessageFadeTime += DeltaTime * 8;
			if (MessageFadeTime > 1.0)
				MessageFadeTime = 1.0;
		}
	} 
	else if ( (MessageFadeTime > 0.0) && (MessageFadeCount == 0) )
	{
		MessageFadeTime -= DeltaTime * 2;
		if (MessageFadeTime < 0.0)
			MessageFadeTime = 0.0;
	}
	WeaponNameFade -= DeltaTime;
}

simulated function DrawMOTD(Canvas Canvas)
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local float InitialY;

	GRI = PlayerPawn(Owner).GameReplicationInfo;
	if ( (GRI == None) || (GRI.GameName == "Game") || (MOTDFadeOutTime <= 0) ) 
		return;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.Style = Style;
	Canvas.bCenter = true;
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.5;
	InitialY = 64*Scale;
	Canvas.SetPos(0.0, InitialY);
	Canvas.StrLen("TEST", XL, YL);
	if ( Level.NetMode != NM_Standalone )
	{
		Canvas.DrawText(GRI.ServerName);
		if ( Canvas.ClipY >= 300 )
		{
			Canvas.SetPos(0.0, InitialY + 6*YL);
			Canvas.DrawText(GRI.MOTDLine1, true);
			Canvas.SetPos(0.0, InitialY + 7*YL);
			Canvas.DrawText(GRI.MOTDLine2, true);
			Canvas.SetPos(0.0, InitialY + 8*YL);
			Canvas.DrawText(GRI.MOTDLine3, true);
			Canvas.SetPos(0.0, InitialY + 9*YL);
			Canvas.DrawText(GRI.MOTDLine4, true);
		}
	}
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.6;
	Canvas.SetPos(0.0, InitialY + YL);
	Canvas.DrawText(GRI.GameName, true);
	Canvas.SetPos(0.0, InitialY + 2*YL);
	Canvas.DrawText(MapTitleString2@Level.Title, true);
	if ( Canvas.ClipY >= 300 )
	{
		Canvas.SetPos(0.0, InitialY + 3*YL);
		Canvas.DrawText(AuthorString2@Level.Author, true);
		if (Level.IdealPlayerCount != "")
		{
			Canvas.SetPos(0.0, InitialY + 4*YL);
			Canvas.DrawText(PlayerCountString$Level.IdealPlayerCount, true);
		}
	}
	Canvas.bCenter = false;
}

simulated function DrawCrossHair( canvas Canvas, int X, int Y)
{
	local float XScale, PickDiff;
	local float XLength;
	local texture T;

 	if (Crosshair>=CrosshairCount) Return;
	if ( Canvas.ClipX < 512 )
		XScale = 0.5;
	else
		XScale = FMax(1, int(0.1 + Canvas.ClipX/640.0));
	PickDiff = Level.TimeSeconds - PickupTime;
	if ( PickDiff < 0.4 )
	{
		if ( PickDiff < 0.2 )
			XScale *= (1 + 5 * PickDiff);
		else
			XScale *= (3 - 5 * PickDiff);
	}
	XLength = XScale * 64.0;

	Canvas.bNoSmooth = False;
	if ( PlayerOwner.Handedness == -1 )
		Canvas.SetPos(0.503 * (Canvas.ClipX - XLength), 0.504 * (Canvas.ClipY - XLength));
	else if ( PlayerOwner.Handedness == 1 )
		Canvas.SetPos(0.497 * (Canvas.ClipX - XLength), 0.496 * (Canvas.ClipY - XLength));
	else
		Canvas.SetPos(0.5 * (Canvas.ClipX - XLength), 0.5 * (Canvas.ClipY - XLength));
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = 15 * CrosshairColor;

	T = CrossHairTextures[Crosshair];
	if( T == None )
		T = LoadCrosshair(Crosshair);

	Canvas.DrawTile(T, XLength, XLength, 0, 0, 64, 64);
	Canvas.bNoSmooth = True;
	Canvas.Style = Style;
}

simulated function DrawTypingPrompt( canvas Canvas, console Console )
{
	local string TypingPrompt;
	local float XL, YL, YPos, XOffset;
	local float MyOldClipX, OldClipY, OldOrgX, OldOrgY;

	MyOldClipX = Canvas.ClipX;
	OldClipY = Canvas.ClipY;
	OldOrgX = Canvas.OrgX;
	OldOrgY = Canvas.OrgY;

	Canvas.DrawColor = GreenColor;
	TypingPrompt = "(>"@Console.TypedStr$"_";
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen( "TEST", XL, YL );
	YPos = YL*4 + 8;
	if (PawnOwner.PlayerReplicationInfo.bIsSpectator || bHideHUD || bHideFaces)
		XOffset = 0;
	else
		XOffset = FMax(0,FaceAreaOffset + 15*Scale + YPos);
	Canvas.SetOrigin(XOffset, FMax(0,YPos + 7*Scale));
	Canvas.SetClip( 760*Scale, Canvas.ClipY );
	Canvas.SetPos( 0, 0 );
	Canvas.DrawText( TypingPrompt, false );
	Canvas.SetOrigin( OldOrgX, OldOrgY );
	Canvas.SetClip( MyOldClipX, OldClipY );
}

// Entry point for string messages.
simulated function Message( PlayerReplicationInfo PRI, coerce string Msg, name MsgType )
{
	local int i;
	local Class<LocalMessage> MessageClass;

	switch (MsgType)
	{
		case 'Say':
		case 'TeamSay':
			MessageClass = class'SayMessagePlus';
			break;
		case 'CriticalEvent':
			MessageClass = class'CriticalStringPlus';
			LocalizedMessage( MessageClass, 0, None, None, None, Msg );
			return;
		case 'DeathMessage':
			MessageClass = class'RedSayMessagePlus';
			break;
		case 'Pickup':
			PickupTime = Level.TimeSeconds;
		default:
			MessageClass = class'StringMessagePlus';
			break;
	}

	if ( ClassIsChildOf(MessageClass, class'SayMessagePlus') || 
				     ClassIsChildOf(MessageClass, class'TeamSayMessagePlus') )
	{
		FaceTexture = PRI.TalkTexture;
		if ( FaceTexture != None )
			FaceTime = Level.TimeSeconds + 3;
		if ( Msg == "" )
			return;
	} 
	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			// Add the message here.
			ShortMessageQueue[i].Message = MessageClass;
			ShortMessageQueue[i].Switch = 0;
			ShortMessageQueue[i].RelatedPRI = PRI;
			ShortMessageQueue[i].OptionalObject = None;
			ShortMessageQueue[i].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
			if ( MessageClass.Default.bComplexString )
				ShortMessageQueue[i].StringMessage = Msg;
			else
				ShortMessageQueue[i].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
			return;
		}
	}

	// No empty slots.  Force a message out.
	for (i=0; i<3; i++)
		CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

	ShortMessageQueue[3].Message = MessageClass;
	ShortMessageQueue[3].Switch = 0;
	ShortMessageQueue[3].RelatedPRI = PRI;
	ShortMessageQueue[3].OptionalObject = None;
	ShortMessageQueue[3].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
	if ( MessageClass.Default.bComplexString )
		ShortMessageQueue[3].StringMessage = Msg;
	else
		ShortMessageQueue[3].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
}

simulated function bool DisplayMessages( canvas Canvas )
{
	return true;
}

simulated function float DrawNextMessagePart(Canvas Canvas, string MString, float XOffset, int YPos)
{
	local float XL, YL;

	Canvas.SetPos(4 + XOffset, YPos);
	Canvas.StrLen( MString, XL, YL );
	Canvas.DrawText( MString, false );
	return (XOffset + XL);
}



//=====================================================================
// Deal with a localized message.

simulated function LocalizedMessage( class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional String CriticalString )
{
	local int i;

	if ( ClassIsChildOf( Message, class'PickupMessagePlus' ) )
		PickupTime = Level.TimeSeconds;

	if ( !Message.Default.bIsSpecial )
	{
		if ( ClassIsChildOf(Message, class'SayMessagePlus') || 
						 ClassIsChildOf(Message, class'TeamSayMessagePlus') )
		{
			FaceTexture = RelatedPRI_1.TalkTexture;
			if ( FaceTexture != None )
				FaceTime = Level.TimeSeconds + 3;
		} 
		// Find an empty slot.
		for (i=0; i<4; i++)
		{
			if ( ShortMessageQueue[i].Message == None )
			{
				ShortMessageQueue[i].Message = Message;
				ShortMessageQueue[i].Switch = Switch;
				ShortMessageQueue[i].RelatedPRI = RelatedPRI_1;
				ShortMessageQueue[i].OptionalObject = OptionalObject;
				ShortMessageQueue[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				if ( Message.Default.bComplexString )
					ShortMessageQueue[i].StringMessage = CriticalString;
				else
					ShortMessageQueue[i].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
				return;
			}

		}
		// No empty slots.  Force a message out.
		for (i=0; i<3; i++)
			CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

		ShortMessageQueue[3].Message = Message;
		ShortMessageQueue[3].Switch = Switch;
		ShortMessageQueue[3].RelatedPRI = RelatedPRI_1;
		ShortMessageQueue[3].OptionalObject = OptionalObject;
		ShortMessageQueue[3].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		if ( Message.Default.bComplexString )
			ShortMessageQueue[3].StringMessage = CriticalString;
		else
			ShortMessageQueue[3].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		return;
	} 
	else 
	{
		if ( CriticalString == "" )
			CriticalString = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		if ( Message.Default.bIsUnique )
		{
			for (i=0; i<10; i++)
			{
				if (LocalMessages[i].Message != None)
				{
					if ((LocalMessages[i].Message == Message) 
						|| (LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, 24, 640) 
								== Message.Static.GetOffset(Switch, 24, 640)) ) 
					{
						LocalMessages[i].Message = Message;
						LocalMessages[i].Switch = Switch;
						LocalMessages[i].RelatedPRI = RelatedPRI_1;
						LocalMessages[i].OptionalObject = OptionalObject;
						LocalMessages[i].LifeTime = Message.Default.Lifetime;
						LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
						LocalMessages[i].StringMessage = CriticalString;
						LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
						LocalMessages[i].XL = 0;
						return;
					}
				}
			}
		}
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message == None)
			{
				LocalMessages[i].Message = Message;
				LocalMessages[i].Switch = Switch;
				LocalMessages[i].RelatedPRI = RelatedPRI_1;
				LocalMessages[i].OptionalObject = OptionalObject;
				LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				LocalMessages[i].StringMessage = CriticalString;
				LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
				LocalMessages[i].LifeTime = Message.Default.Lifetime;
				LocalMessages[i].XL = 0;
				return;
			}
		}

		// No empty slots.  Force a message out.
		for (i=0; i<9; i++)
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);

		LocalMessages[9].Message = Message;
		LocalMessages[9].Switch = Switch;
		LocalMessages[9].RelatedPRI = RelatedPRI_1;
		LocalMessages[9].OptionalObject = OptionalObject;
		LocalMessages[9].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		LocalMessages[9].StringMessage = CriticalString;
		LocalMessages[9].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
		LocalMessages[9].LifeTime = Message.Default.Lifetime;
		LocalMessages[9].XL = 0;
		return;
	}
}

simulated function DrawEnemies(Canvas Canvas)
{
	local Enemy E;
	local float 	Ypos, XL, YL, Xpos, Dist;
	local Vector	dir;
	local Vector	loc;
	local Vector	X,Y,Z;
	
	if (PlayerOwner == None)
	{
		return;
	}

	GetAxes(Owner.Rotation, X, Y, Z);
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;

	foreach VisibleCollidingActors(class'Enemy', E, 750, Owner.Location, true)
		{

		Dir = E.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		Canvas.StrLen(E.HUDname$"("$E.Health$")", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * Canvas.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > Canvas.ClipX - XL)
				{
				Xpos = Canvas.ClipX - XL;
				}
			YPos = 0.5 * Canvas.ClipY * (1 - 1.4 * (Dir Dot Z));
			Canvas.SetPos(Xpos , YPos );
			Canvas.DrawColor = E.HUDcolor;
			Canvas.DrawText(E.HUDname$"("$E.Health$")", true);
			}
		}
}

simulated function DrawPickups(Canvas Canvas)
{
	local Inventory Inv;
	local float 	Ypos, XL, YL, Xpos, Dist;
	local Vector	dir;
	local Vector	loc;
	local Vector	X,Y,Z;
	
	if (PlayerOwner == None)
	{
		return;
	}

	GetAxes(Owner.Rotation, X, Y, Z);
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;

	foreach VisibleCollidingActors(class'Inventory', Inv, 750, Owner.Location, true)
		{

		Dir = Inv.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		Canvas.StrLen(Inv.ItemName, XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * Canvas.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > Canvas.ClipX - XL)
				{
				Xpos = Canvas.ClipX - XL;
				}
			YPos = 0.5 * Canvas.ClipY * (1 - 1.4 * (Dir Dot Z));
			Canvas.SetPos(Xpos , YPos );
			if ( Inv.IsA('MercWarriorsWeapon') )
				{
				Canvas.DrawColor = MercWarriorsWeapon(Inv).ItemColor;
				Canvas.DrawText(MercWarriorsWeapon(Inv).WeaponClass@Inv.ItemName, true);
				}
			else
				if ( Inv.IsA('MercWarriorsAmmo') )
					{
					Canvas.DrawColor = MercWarriorsAmmo(Inv).ItemColor;
					Canvas.DrawText(Inv.ItemName, true);
					}
			else
				if ( Inv.IsA('MercWarriorsPickup') )
					{
					Canvas.DrawColor = MercWarriorsPickup(Inv).ItemColor;
					Canvas.DrawText(Inv.ItemName, true);
					}
			else
				{
				Canvas.DrawColor = FaceColor;
				Canvas.DrawText(Inv.ItemName, true);
				}
			}
		}
}

defaultproperties
{
     VersionMessage="Version"
     PlayerCountString="Ideal Player Load:"
     MapTitleString="in"
     AuthorString="by"
     MapTitleString2="Map:"
     AuthorString2="Author:"
     RankString="Rank:"
     SpreadString="Spread:"
     CrosshairCount=9
     CrossHairs(0)="Botpack.CHair1"
     CrossHairs(1)="Botpack.CHair2"
     CrossHairs(2)="Botpack.CHair3"
     CrossHairs(3)="Botpack.CHair4"
     CrossHairs(4)="Botpack.CHair5"
     CrossHairs(5)="Botpack.CHair6"
     CrossHairs(6)="Botpack.CHair7"
     CrossHairs(7)="Botpack.CHair8"
     CrossHairs(8)="Botpack.CHair9"
     FP1(0)=Texture'Botpack.FacePanel.FacePanel1'
     FP1(1)=Texture'Botpack.FacePanel.FacePanel1b'
     FP1(2)=Texture'Botpack.FacePanel.FacePanel1a'
     FP2(0)=Texture'Botpack.FacePanel.FacePanel2'
     FP2(1)=Texture'Botpack.FacePanel.FacePanel2b'
     FP2(2)=Texture'Botpack.FacePanel.FacePanel2a'
     FP3(0)=Texture'Botpack.FacePanel.FacePanel3'
     FP3(1)=Texture'Botpack.FacePanel.FacePanel3b'
     FP3(2)=Texture'Botpack.FacePanel.FacePanel3a'
     bStartUpMessage=True
     bUseTeamColor=True
     Opacity=15
     HUDScale=1.000000
     StatusScale=1.000000
     WeaponScale=0.800000
     FavoriteHUDColor=(B=16)
     CrosshairColor=(G=16)
     Style=3
     WhiteColor=(R=255,G=255,B=255)
     RedColor=(R=255)
     GreenColor=(G=255)
     CyanColor=(G=255,B=255)
     UnitColor=(R=1,G=1,B=1)
     BlueColor=(B=255)
     GoldColor=(R=255,G=255)
     PurpleColor=(R=255,B=255)
     TurqColor=(G=128,B=255)
     GrayColor=(R=200,G=200,B=200)
     FaceColor=(R=50,G=50,B=50)
	 CycleColor=(R=255,G=255,B=255)
	 bCycleUp=True
	 CC=0
     IdentifyName="Name:"
     IdentifyHealth="Health:"
     IdentifyCallsign="Callsign:"
     LiveFeed="Live Feed from "
     ScoreTime=-10000000.000000
     ServerInfoClass=Class'Botpack.ServerInfo'
     FontInfoClass="Botpack.FontInfo"
     HUDConfigWindowType="UTMenu.UTChallengeHUDConfig"
}
